/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.capability.size;

import java.util.EnumMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.capability.size.CapabilityItemSize;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemSizeHandler
implements ICapabilityProvider,
IItemSize {
    private static final EnumMap<Size, EnumMap<Weight, ItemSizeHandler[]>> CACHE = new EnumMap(Size.class);
    private final Size size;
    private final Weight weight;
    private final boolean canStack;

    public static ItemSizeHandler get(Size size, Weight weight, boolean canStack) {
        ItemSizeHandler[] handlers;
        EnumMap<Weight, Object> nested = CACHE.get((Object)size);
        if (nested == null) {
            nested = new EnumMap(Weight.class);
            CACHE.put(size, nested);
        }
        if ((handlers = nested.get((Object)weight)) == null) {
            handlers = new ItemSizeHandler[2];
            nested.put(weight, (ItemSizeHandler[])handlers);
        }
        if (handlers[canStack ? 1 : 0] == null) {
            handlers[canStack ? 1 : 0] = new ItemSizeHandler(size, weight, canStack);
        }
        return handlers[canStack ? 1 : 0];
    }

    public static ItemSizeHandler getDefault() {
        return ItemSizeHandler.get(Size.SMALL, Weight.LIGHT, true);
    }

    public ItemSizeHandler(Size size, Weight weight, boolean canStack) {
        this.size = size;
        this.weight = weight;
        this.canStack = canStack;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemSize.ITEM_SIZE_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemSize.ITEM_SIZE_CAPABILITY ? this : null);
    }

    @Override
    @Nonnull
    public Size getSize(@Nonnull ItemStack stack) {
        return this.size;
    }

    @Override
    @Nonnull
    public Weight getWeight(@Nonnull ItemStack stack) {
        return this.weight;
    }

    @Override
    public boolean canStack(@Nonnull ItemStack stack) {
        return this.canStack;
    }

    @Override
    public int getStackSize(@Nonnull ItemStack stack) {
        return this.canStack ? this.weight.stackSize : 1;
    }
}

